%define _unpackaged_files_terminate_build 1
%set_perl_req_method relaxed

Name: pve-qemu-server
Summary: PVE Qemu Server Tools
Version: 8.3.12
Release: alt2
License: AGPL-3.0+
Group: System/Servers
Url: https://www.proxmox.com
Vcs: git://git.proxmox.com/git/qemu-server.git
Source: %name-%version.tar
Source71: basealt_bootsplash.jpg

ExclusiveArch: x86_64 aarch64

# from debian/control
Provides: qemu-server = %EVR
Obsoletes: qemu-server < %EVR

Requires: socat genisoimage pve-qemu-system >= 7.1 swtpm swtpm-tools proxmox-websocket-tunnel
Conflicts: pve-ha-manager < 4.0.1 pve-manager < 6.0.13
BuildRequires: glib2-devel libjson-c-devel
BuildRequires: pve-common >= 8.0.2 pve-guest-common >= 5.2.2 pve-firewall pve-ha-manager
BuildRequires: pve-doc-generator >= 6.2.5 pve-storage >= 8.2.10 pve-qemu-system >= 7.1
BuildRequires: perl(Term/ReadLine.pm) perl(IO/Multiplex.pm) perl(JSON.pm) perl(Time/HiRes.pm) perl(UUID.pm)
BuildRequires: perl(Crypt/OpenSSL/Random.pm) perl(XML/LibXML.pm) perl(Digest/SHA.pm) perl(URI/Escape.pm)

%description
%summary.
This package contains the Qemu Server tools used by Proxmox VE.

%prep
%setup
sed -i 's!SERVICEDIR=/lib/systemd/system!SERVICEDIR=%_unitdir!' qmeventd/Makefile
sed -i 's!SERVICEDIR=/lib/systemd/system!SERVICEDIR=%_unitdir!' query-machine-capabilities/Makefile

%build
%make_build qmeventd -C qmeventd
%make_build query-machine-capabilities -C query-machine-capabilities

%install
%makeinstall_std
install -m0644 %SOURCE71 %buildroot%_datadir/qemu-server/bootsplash.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-cirrus.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-std.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-vmware.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-qxl.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-serial0.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-serial1.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-serial2.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-serial3.jpg
ln -s bootsplash.jpg %buildroot%_datadir/qemu-server/bootsplash-virtio.jpg

%files
%config(noreplace) %_sysconfdir/modules-load.d/qemu-server.conf
%_unitdir/qmeventd.service
%_unitdir/qmeventd.socket
%_unitdir/pve-query-machine-capabilities.service
%_prefix/libexec/qemu-server
%_prefix/lib/qemu-server
%_sbindir/*
%_datadir/bash-completion/completions/*
%_datadir/zsh/vendor-completions/*
%_datadir/qemu-server
%_localstatedir/qemu-server
%_man1dir/*
%_man5dir/*
%_man8dir/*

%perl_vendor_privlib/PVE/API2/*
%perl_vendor_privlib/PVE/CLI/*
%perl_vendor_privlib/PVE/QemuServer
%perl_vendor_privlib/PVE/VZDump
%perl_vendor_privlib/PVE/*.pm
%perl_vendor_privlib/PVE/QemuConfig/NoWrite.pm

%changelog
