Name:    pyinstaller
Version: 6.1.0
Release: alt1

Summary: Freeze (package) Python programs into stand-alone executables
License: GPL-2.0+
Group:   Development/Python3

URL: https://pyinstaller.org
VCS: https://github.com/pyinstaller/pyinstaller

Packager: Andrey Cherepanov <cas@altlinux.org>

Requires: python3-module-pyinstaller-hooks-contrib

Source: %name-%version.tar
Patch0: %name-distutils-is-deprecated.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: zlib-devel
BuildRequires: libcmocka-devel

%filter_from_requires /python3(macholib.*)/d
%add_python3_req_skip pywintypes pefile pyimod01_archive pyimod02_importers pyimod03_ctypes

%description
PyInstaller bundles a Python application and all its dependencies into a single
package. The user can run the packaged app without installing a Python
interpreter or any modules.

%prep
%setup
%patch0 -p1
# Remove binary files
rm -rf PyInstaller/bootloader/*

%ifarch %e2k
# old waf didn't know of e2k
sed -i "/xtensa/a\    '__e2k__': 'e2k'," bootloader/waflib/Tools/c_config.py
# lcc 1.26 sneezes at pyi_main.c:57
sed -i "s/'-Werror', /&'-Wno-error=unused-but-set-variable', /" \
	bootloader/wscript
%endif

%build
%python3_build_debug

%install
%python3_install
# Fix path for executable files
if [ "%_libexecdir" != "%_libdir" ]; then
    mv %buildroot%_libexecdir %buildroot%_libdir
fi

%files
%doc README.rst
%_bindir/*
%python3_sitelibdir/PyInstaller
%python3_sitelibdir/*.egg-info

%changelog
