%define _libexecdir %_prefix/libexec
%define modname dbus-python

%def_enable check
%def_disable installed_tests
%add_findreq_skiplist %_libexecdir/installed-tests/%modname/test/*.py
%def_disable documentation

Name: python-module-dbus
Version: 1.2.18
Release: alt2

Summary: Python bindings for D-BUS library
License: MIT
Group: Development/Python
Url: https://www.freedesktop.org/wiki/Software/DBusBindings

##Source: dbus-python-%version.tar
Source: https://dbus.freedesktop.org/releases/dbus-python/dbus-python-%version.tar.gz

%define dbus_ver 1.8
%define glib_ver 2.40

%setup_python_module dbus
Requires: dbus
Provides: %modname = %EVR
Provides: %name-data = %EVR
Obsoletes: %name-data < %version-%release

BuildRequires: autoconf-archive libdbus-devel >= %dbus_ver libgio-devel >= %glib_ver
BuildRequires: python-devel >= 2.7 python-modules-unittest
BuildRequires: python-module-pygobject3
%{?_enable_documentation:BuildRequires: python-module-sphinx python-module-sphinx_rtd_theme}

%description
D-Bus python bindings for use with python programs.

%package gobject
Summary: Python bindings for D-BUS library
Group: Development/Python
Requires: python-module-dbus = %EVR

%description gobject
D-Bus bindings for use with python programs
(gobject introspection bindings).

%package devel
Summary: Python bindings for D-BUS library (devel package)
Group: Development/Python

%description devel
D-Bus python bindings for use with python programs.
Development package.

%package devel-doc
Summary: Development documentation for %modname
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-devel < %version-%release

%description devel-doc
Development documentation for %modname.

%package tests
Summary: Tests for the %name package
Group: Development/Python
Requires: %name = %EVR
Requires: dbus-tools

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed python-dbus package.

%prep
%setup -n %modname-%version

%build
%define options %{?_enable_installed_tests:--enable-installed-tests} %{subst_enable documentation}
export am_cv_python_pythondir=%python_sitelibdir
export am_cv_python_pyexecdir=%python_sitelibdir
%autoreconf
%configure %options \
	PYTHON=%__python \
	PYTHON_LIBS="$(python-config --libs)"
%make_build

%install
%makeinstall_std

%check
%make check

%files
%python_sitelibdir/*.so
%python_sitelibdir/dbus/
%doc AUTHORS COPYING NEWS

%exclude %python_sitelibdir/*.la
%exclude %python_sitelibdir/dbus/gobject_service.py*
%exclude %python_sitelibdir/dbus/gi_service.py*

%files gobject
%python_sitelibdir/dbus/gobject_service.py*
%python_sitelibdir/dbus/gi_service.py*

#%files devel
%exclude %_includedir/dbus-1.0/dbus/%modname.h
%exclude %_pkgconfigdir/%modname.pc

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%modname/
%exclude %_libexecdir/installed-tests/%modname/test/__pycache__
%_datadir/installed-tests/%modname/
%endif

%if_enabled documentation
%files devel-doc
%_docdir/%modname/
%endif


%changelog
