%def_disable snapshot

%define modname cairo
%define oname py%modname
%define ver_major 1.18

Name: python-module-%oname
Version: %ver_major.2
Release: alt3

Summary: Pycairo is a set of Python bindings for the cairo vector graphics library
Group: Development/Python
License: LGPL-2.1 and MPL-1.1
Url: https://github.com/pygobject/pycairo

%if_disabled snapshot
Source: %url/releases/download/v%version/%oname-%version.tar.gz
%else
# VCS: https://github.com/pygobject/pycairo.git
Source: %oname-%version.tar
%def_with bootstrap
%endif

%setup_python_module %modname

BuildRequires(pre): rpm-build-python
BuildRequires: libcairo-devel >= 1.13.1
BuildRequires: python-devel
%{?_with_bootstrap:BuildRequires: python-module-Pygments}

%description
The Pycairo bindings are designed to match the cairo C API as closely as
possible, and to deviate only in cases which are clearly better implemented in
a more 'Pythonic' way.

%package devel
Summary: Development files for pycairo
Group: Development/Python
Requires: %name = %EVR
Obsoletes: python-module-pycairo-common-devel
Provides: python-module-pycairo-common-devel = %EVR

%description devel
Development files for pycairo.

%package docs
Summary: Documentation for pycairo
Group: Development/Documentation
BuildArch: noarch

%description docs
Documentation for pycairo.

%prep
%setup -n %oname-%version

# fix pc-file install
subst 's|\"lib\"|"%_lib"|' setup.py

%build
%python_build

%install
%python_install

%files
%python_sitelibdir/%modulename
%doc NEWS README*

%files devel
%dir %_includedir/%oname
%_includedir/%oname/pycairo.h
%_pkgconfigdir/%oname.pc


%changelog
