# TODO: quick3d
%define oname PyQt5

%def_with dbus
%def_with webkit

# Note: check Qt subst below
#define qtver %(rpm -q --qf '%%{VERSION}' libqt5-core | sed -e 's|\\.|_|g')

Name: python3-module-%oname
Version: 5.15.10
Release: alt3

Summary: Python 3 bindings for Qt 5

License: GPLv3
Group: Development/Python3
Url: http://www.riverbankcomputing.co.uk/software/pyqt

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildRequires(pre): rpm-build-intro
BuildRequires(pre): rpm-build-python3 >= 0.1.9.2-alt1

BuildRequires: python3-devel

BuildRequires: python3-module-sip6 >= 6.4
BuildRequires: python3-module-sip6 < 7
BuildRequires: python3-module-PyQt-builder >= 1.9
BuildRequires: python3-module-PyQt-builder < 2

%if_with dbus
BuildRequires: python3-module-dbus
BuildRequires: libdbus-devel
BuildRequires: python3-module-dbus-devel
%endif

BuildRequires: qt5-connectivity-devel qt5-location-devel qt5-multimedia-devel qt5-sensors-devel qt5-serialport-devel
BuildRequires: qt5-svg-devel qt5-tools-devel qt5-websockets-devel qt5-x11extras-devel qt5-xmlpatterns-devel libqt5-qml

# we missed it:
#BuildRequires:    pkgconfig(Enginio)

BuildRequires: pkgconfig(Qt5Bluetooth)
BuildRequires: pkgconfig(Qt5Core)
BuildRequires: pkgconfig(Qt5DBus)
BuildRequires: pkgconfig(Qt5Designer)
BuildRequires: pkgconfig(Qt5Gui)
BuildRequires: pkgconfig(Qt5Help)
BuildRequires: pkgconfig(Qt5Multimedia)
BuildRequires: pkgconfig(Qt5MultimediaWidgets)
BuildRequires: pkgconfig(Qt5Network)
BuildRequires: pkgconfig(Qt5NetworkAuth)
BuildRequires: pkgconfig(Qt5OpenGL)
BuildRequires: pkgconfig(Qt5Positioning)
BuildRequires: pkgconfig(Qt5PrintSupport)
BuildRequires: pkgconfig(Qt5Qml)
BuildRequires: pkgconfig(Qt5Quick)
BuildRequires: pkgconfig(Qt5QuickWidgets)
BuildRequires: pkgconfig(Qt5Sensors)
BuildRequires: pkgconfig(Qt5RemoteObjects)
BuildRequires: pkgconfig(Qt5SerialPort)
BuildRequires: pkgconfig(Qt5Sql)
BuildRequires: pkgconfig(Qt5Svg)
BuildRequires: pkgconfig(Qt5Test)
BuildRequires: pkgconfig(Qt5WebChannel)
%if_with webkit
BuildRequires: pkgconfig(Qt5WebKit)
BuildRequires: pkgconfig(Qt5WebKitWidgets)
%endif
BuildRequires: pkgconfig(Qt5WebSockets)
BuildRequires: pkgconfig(Qt5Widgets)
BuildRequires: pkgconfig(Qt5Xml)
BuildRequires: pkgconfig(Qt5XmlPatterns)
BuildRequires: pkgconfig(Qt5X11Extras)

%if_with dbus
# https://bugzilla.altlinux.org/show_bug.cgi?id=33873
%py3_provides dbus.mainloop.pyqt5
%endif

Requires: python3-module-PyQt5-sip
# mapping from PyPI name
Provides: python3-module-%{pep503_name %oname} = %EVR
Conflicts: python-module-PyQt5 < 5.13.1-alt4

%description
Python 3 bindings for the Qt C++ class library.  Also includes a PyQt5 backend
code generator for Qt Designer.

%package -n python3-module-%oname-devel
Summary: Sip files for python3-module-%oname
Group: Development/Python3
Requires: %name = %EVR

%description -n python3-module-%oname-devel
Python 3 bindings for the Qt C++ class library.  Also includes a PyQt5 backend
code generator for Qt Designer.

%package examples
Summary: PyQt5 examples
Group: Development/Python3
BuildArch: noarch
Requires: %name = %EVR

%description examples
This package contains PyQt5 examples.

%package webkit
Summary: PyQt5 obsoleted webkit
Group: Development/Python3
Requires: %name = %EVR

%description webkit
This package contains PyQt5 webkit bindings.

%package doc
Summary: PyQt5 docs
Group: Development/Python3
BuildArch: noarch
Requires: %name = %EVR

%description doc
This package contains PyQt5 docs.

%prep
%setup

%build
sip-build --confirm-license --no-make --debug \
    --qmake %_qt5_qmake \
    --api-dir=%_qt5_datadir/qsci/
%make_build -C build

%install
%makeinstall_std -C build INSTALL_ROOT=%buildroot

# Remove unused py2 version of uic modules:
rm -rv %buildroot/%python3_sitelibdir/PyQt5/uic/port_v2/

#files doc
#doc doc/*
#doc NEWS README

#files examples
#doc examples

%files
%dir %python3_sitelibdir/PyQt5/
%python3_sitelibdir/PyQt5/uic/
%python3_sitelibdir/PyQt5/__init__.py
%dir %python3_sitelibdir/PyQt5/__pycache__/
%python3_sitelibdir/PyQt5/__pycache__/__init__.*
%python3_sitelibdir/PyQt5/Qt*.so
%python3_sitelibdir/PyQt5/_QOpenGLFunctions*.so
%python3_sitelibdir/*-%version.*dist*
%_libdir/qt5/plugins/PyQt5/
%if_with dbus
%python3_sitelibdir/dbus/mainloop/pyqt5*.so
%endif
%exclude %python3_sitelibdir/PyQt5/QtWebKit.*so
%exclude %python3_sitelibdir/PyQt5/QtWebKitWidgets.*so

%if_with webkit
%files webkit
%python3_sitelibdir/PyQt5/QtWebKit.*so
%python3_sitelibdir/PyQt5/QtWebKitWidgets.*so
%endif

%files devel
%_bindir/pylupdate5
%_bindir/pyrcc5
%_bindir/pyuic5
%dir %_qt5_datadir/
%_qt5_datadir/qsci/
%_libdir/qt5/plugins/designer/libpyqt5*.so
%python3_sitelibdir/PyQt5/bindings/
%python3_sitelibdir/PyQt5/pylupdate*
%python3_sitelibdir/PyQt5/pyrcc*
%python3_sitelibdir/PyQt5/__pycache__/pylupdate*
%python3_sitelibdir/PyQt5/__pycache__/pyrcc*

%changelog
