%define _unpackaged_files_terminate_build 1
%define pypi_name QtAwesome
%define mod_name qtawesome

%def_with check

Name: python3-module-%pypi_name
Version: 1.4.0
Release: alt1.1

Summary: Iconic fonts in PyQt and PySide applications
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/QtAwesome/
Vcs: https://github.com/spyder-ide/qtawesome

BuildArch: noarch

Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %pypi_name} = %EVR
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
BuildRequires: xvfb-run
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-qt
BuildRequires: python3-module-pyqt5
%endif

%description
QtAwesome enables iconic fonts such as Font Awesome and Elusive Icons in PyQt
and PySide applications.

It started as a Python port of the QtAwesome C++ library by Rick Blommers.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- xvfb-run -- python3 example.py
# skip silly test (doesn't work during packaging due to pathing)
%pyproject_run -- xvfb-run -- pytest -vra \
  --deselect qtawesome/tests/test_qtawesome.py::test_get_fonts_info

%files
%doc CHANGELOG.md LICENSE.txt README.md
%_bindir/qta-browser
%_bindir/qta-install-fonts-all-users
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
