%define oname TurboGears2

Name: python3-module-%oname
Version: 2.4.3
Release: alt2

Summary: Back-to-front web development in Python

License: MIT
Group: Development/Python
Url: http://www.turbogears.org

#BuildPreReq: python-module-distribute
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools rpm-build-python3 time

Source: %name-%version.tar

# not need for python3
%add_python3_req_skip tgming.auth

%description
TurboGears brings together four major pieces to create an
easy to install, easy to use web megaframework. It covers
everything from front end (MochiKit JavaScript for the browser,
Kid for templates in Python) to the controllers (CherryPy) to
the back end (SQLObject).

The TurboGears project is focused on providing documentation
and integration with these tools without losing touch
with the communities that already exist around those tools.

TurboGears is easy to use for a wide range of web applications.

%package -n python3-module-%oname-tests
Summary: Tests for TurboGears (Python 3)
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-tests
TurboGears brings together four major pieces to create an
easy to install, easy to use web megaframework. It covers
everything from front end (MochiKit JavaScript for the browser,
Kid for templates in Python) to the controllers (CherryPy) to
the back end (SQLObject).

The TurboGears project is focused on providing documentation
and integration with these tools without losing touch
with the communities that already exist around those tools.

TurboGears is easy to use for a wide range of web applications.

This package contains tests for TurboGears.

%prep
%setup

%build
%python3_build

%install
%python3_install

%files
%doc *.txt *.rst
%python3_sitelibdir/*

%changelog
