%define oname argcomplete

%def_with check

Name: python3-module-argcomplete
Version: 3.5.1
Release: alt1

Summary: Bash tab completion for argparse

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/argcomplete/

Source: %name-%version.tar
Patch: argcomplete-3.5.0-skip-test.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pexpect
BuildRequires: python3-module-pip
BuildRequires: zsh
BuildRequires: /dev/pts
%endif

%description
Argcomplete provides easy, extensible command line tab completion of
arguments for your Python script.

It makes two assumptions:

* You're using bash or zsh as your shell
* You're using argparse to manage your command line arguments/options

%prep
%setup
%patch -p1

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
%pyproject_install

%check
# https://github.com/kislyuk/argcomplete/issues/255
sed -i -e "1s|#!.*python.*|#!%__python3|" test/prog test/*.py argcomplete/scripts/*
sed -i -e "s|python |python3 |" test/test.py
export PYTHONPATH=%buildroot%python3_sitelibdir
export PATH=$PATH:%buildroot%_bindir
%pyproject_run -- python3 ./test/test.py -v

%files
%doc README.*
%_bindir/activate-global-python-argcomplete
%_bindir/python-argcomplete-check-easy-install-script
%_bindir/register-python-argcomplete
%python3_sitelibdir/argcomplete/
%python3_sitelibdir/%{pyproject_distinfo %oname}

%changelog
