%define _unpackaged_files_terminate_build 1
%define pypi_name Arpeggio
%define mod_name arpeggio
%def_with check

Name: python3-module-%mod_name
Version: 2.0.2
Release: alt1.1

Summary: Parser interpreter based on PEG grammars written in Python
License: MIT
Group: Development/Python3
Url: https://github.com/igordejanovic/Arpeggio
BuildArch: noarch

Source0: Arpeggio-%version.tar

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

# docs build
BuildRequires: python3(mike)

%if_with check
BuildRequires: python3(pytest)
%endif

%py3_provides %pypi_name

%description
Arpeggio is a recursive descent parser with memoization based on PEG
grammars (aka Packrat parser).

%package tests
Summary: Test suite for %name
Group: Development/Python3
%description tests
%summary

%prep
%setup -n Arpeggio-%version
# A bit of hack here
## python3 -c "import configparser; config = configparser.ConfigParser(); config.read('setup.cfg'); config['options']['setup_requires']=''; print(config['options']['setup_requires']); config.write(open('setup.cfg', 'w'))"

%build
%pyproject_build
mkdocs build

%install
%pyproject_install

%check
%tox_create_default_config
%tox_check_pyproject -- -vra arpeggio/tests

%files
%doc site examples
%python3_sitelibdir/%mod_name
%exclude %python3_sitelibdir/%mod_name/tests/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%files tests
%python3_sitelibdir_noarch/%mod_name/tests/

%changelog
