%define pypi_name arrow
%def_disable docs
# 25 failed, 1804 passed, 1 xfailed, 1 xpassed in 33.01s
# probably dateutil too old or need to rebuild
%def_disable check

Name: python3-module-%pypi_name
Version: 1.3.0
Release: alt1.1

Summary: Better dates & times for Python
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.python.org/pypi/arrow/

Vcs: https://github.com/crsmithdev/arrow.git
Source: https://pypi.io/packages/source/a/%pypi_name/%pypi_name-%version.tar.gz

BuildArch: noarch

%define dateutil_ver 2.7.0

Requires: python3-module-python-dateutil >= %dateutil_ver

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(wheel) python3(flit_core)
BuildRequires: python3-module-python-dateutil >= %dateutil_ver
%{?_enable_docs:
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3(sphinx) python3(sphinx_autodoc_typehints}
%{?_enable_check:BuildRequires: python3(tox) python3(dateparser) >= 1.0
BuildRequires: python3(pytest_mock) python3(pytest_cov) python3(simplejson)}

%description
Arrow is a Python library that offers a sensible, human-friendly
approach to creating, manipulating, formatting and converting dates,
times, and timestamps. It implements and updates the datetime type,
plugging gaps in functionality, and provides an intelligent module API
that supports many common creation scenarios. Simply put, it helps you
work with dates and times with fewer imports and a lot less code.

%prep
%setup -n %pypi_name-%version
#sed -i 's/pytest/py.test3/' tox.ini

%build
%pyproject_build

%install
%pyproject_install

%if_enabled docs
export PYTHONPATH=%buildroot%python3_sitelibdir
SPHINXBUILD=sphinx-build-3 %make -C docs html
mkdir man
cp -fR docs/_build/html/* man/
%endif

%check
%tox_check

%files
%python3_sitelibdir/%pypi_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}
%doc *.rst LICENSE
%{?_enable_docs: man/}

%changelog
