%define _unpackaged_files_terminate_build 1
%define pypi_name Automat
%define mod_name automat

%def_with check

Name: python3-module-%mod_name
Version: 25.4.16
Release: alt1.1
Summary: Self-service finite-state machines for the programmer on the go
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/Automat/
Vcs: https://github.com/glyph/Automat
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
%py3_provides %pypi_name
Provides: python3-module-%pypi_name = %EVR
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra visualize
%pyproject_builddeps_check
%endif

%description
Automat is a library for concise, idiomatic Python expression of finite-state
automata (particularly deterministic finite-state transducers).

%package visualize
Summary: %summary
Group: Development/Python3
Requires: %name
%pyproject_runtimedeps_metadata_extra visualize
Provides: %name+visualize = %EVR

%description visualize
Extra 'visualize' for %pypi_name.

%prep
%setup
%autopatch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_tox tox.ini testenv
%endif

%build
%pyproject_build

%install
%pyproject_install

rm -r %buildroot%python3_sitelibdir/automat/_test/

%check
%pyproject_run_pytest -ra -Wignore src/automat/_test

%files
%python3_sitelibdir/%mod_name/
%exclude %python3_sitelibdir/%mod_name/_visualize.py
%exclude %python3_sitelibdir/%mod_name/__pycache__/_visualize.*
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%files visualize
%_bindir/automat-visualize
%python3_sitelibdir/%mod_name/_visualize.py
%python3_sitelibdir/%mod_name/__pycache__/_visualize.*

%changelog
