%define _unpackaged_files_terminate_build 1

%define pypi_name boto3
%def_with check

Name: python3-module-%pypi_name
Version: 1.34.49
Release: alt1
Summary: The AWS SDK for Python
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/boto3/
Vcs: https://github.com/boto/boto3
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
# this version includes debundler
Requires: python3-module-botocore >= 1.27.42-alt1
# botocore.vendored doesn't provide subpackages
%filter_from_requires /python3(botocore\.vendored\..*)/d
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
Boto is the Amazon Web Services (AWS) Software Development Kit (SDK) for
Python, which allows Python developers to write software that makes use
of services like Amazon S3 and Amazon EC2.

WARNING: Boto 3 is in developer preview and should not be used in
production yet! Please try it out and give feedback by opening issues or
pull requests on this repository. Thanks!

%prep
%setup
%autopatch1 -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile requirements-dev.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- python scripts/ci/run-tests

%files
%doc README.*
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
