%define modname cairosvg
%define eggname CairoSVG

%def_with check

Name:               python3-module-cairosvg
Version:            2.7.1
Release:            alt1.2
Summary:            A Simple SVG Converter for Cairo

Group:              Development/Python3
License:            LGPLv3+
URL:                https://pypi.org/project/CairoSVG/
VCS:		    https://github.com/Kozea/CairoSVG.git
Source0:            %name-%version.tar
Patch0:             cairosvg-2.7.1-Use-underscore-in-setup.cfg-instead-of-deprecated-da.patch

BuildArch:          noarch

BuildRequires(pre): rpm-build-python3
BuildRequires:      python3-module-setuptools
BuildRequires: 	    python3-module-wheel
%if_with check
BuildRequires: 	    python3-module-pytest
BuildRequires:      python3-module-cairocffi
BuildRequires:      libcairo
BuildRequires:      python3-module-cssselect2
BuildRequires:      python3-module-Pillow
BuildRequires:      python3-module-tinycss2
BuildRequires:      python3-module-defusedxml
%endif
Requires:           python3-module-pycairo

Conflicts: python-module-cairosvg
Obsoletes: python-module-cairosvg

%description
CairoSVG is a SVG converter based on Cairo. It can export SVG files to PDF,
PostScript and PNG files.

For further information, please visit the CairoSVG Website
http://www.cairosvg.org

%prep
%setup
%autopatch -p1

%build
%pyproject_build

%install
%pyproject_install

# remove tests
rm -rf %buildroot%python3_sitelibdir/%modname/test_api.py
rm -rf %buildroot%python3_sitelibdir/%modname/__pycache__/test_api.*

%check
%pyproject_run_pytest -v --ignore test_non_regression

%files
%doc README.rst NEWS.rst
%_bindir/cairosvg
%python3_sitelibdir/%modname/
%python3_sitelibdir/%{pyproject_distinfo cairosvg}/

%changelog
