%define oname coverage

%def_without check
%def_without doc

Name: python3-module-coverage
Version: 7.3.2
Release: alt1

Summary: A tool for measuring code coverage of Python programs

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/coverage/

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3

%if_with doc
BuildRequires: libenchant python3-module-sphinx
#BuildRequires: python3-module-sphinx_rtd_theme
%endif

%if_with check
BuildRequires: python3(eventlet)
BuildRequires: python3(flaky)
BuildRequires: python3(gevent)
BuildRequires: python3(mock)
BuildRequires: python3(PyContracts)
BuildRequires: python3(pytest-xdist)
BuildRequires: python3(tox)
BuildRequires: python3(unittest_mixins)
%endif

Conflicts: python-module-coverage

%description
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

Coverage measurement is typically used to gauge the effectiveness of
tests. It can show which parts of your product code are being exercised
by tests, and which are not.

%package doc
Summary: Documentation for Coverage python module
Group: Development/Documentation
BuildArch: noarch

%description doc
Coverage.py is a tool for measuring code coverage of Python programs. It
monitors your program, noting which parts of the code have been
executed, then analyzes the source to identify code that could have been
executed but was not.

This package contains documentation for Coverage.py.

%prep
%setup

%build
%add_optflags -fno-strict-aliasing
%python3_build_debug

export PYTHONPATH=$PWD
%if_with doc
%make_build dochtml
#make_build pickle
%endif

%install
%python3_install
ln -s coverage3 %buildroot%_bindir/python3-coverage

%if_with doc
install -d %buildroot%_docdir/%name
cp -fR doc/_build/html/* %buildroot%_docdir/%name/
#cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%check
# don't measure coverage of ourselves
export COVERAGE_COVERAGE=no
pytest3

%files
%doc CHANGES.rst README.rst
%_bindir/coverage
%_bindir/coverage3
%_bindir/coverage-%_python3_version
%_bindir/python3-coverage
%python3_sitelibdir/%oname
%python3_sitelibdir/*.egg-info

%if_with doc
%files doc
%_docdir/%name
%endif

%changelog
