%define _unpackaged_files_terminate_build 1
%define pypi_name cssutils
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 2.11.0
Release: alt1
Summary: CSS Cascading Style Sheets library for Python
License: LGPL-3.0
Group: Development/Python3
Url: https://pypi.org/project/cssutils/
Vcs: https://github.com/jaraco/cssutils
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
# manually manage extras dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata_extra testing
%endif

%description
A Python package to parse and build CSS Cascading Style Sheets. DOM only, not
any rendering facilities!

%prep
%setup
%autopatch -p1
%pyproject_scm_init
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra -Wignore -m 'not internet'

%files
%_bindir/csscapture
%_bindir/csscombine
%_bindir/cssparse
%python3_sitelibdir/%mod_name/
%exclude %python3_sitelibdir/%mod_name/tests/
%python3_sitelibdir/encutils/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
