%define _unpackaged_files_terminate_build 1
%define oname dirty-validators

%def_with check

Name: python3-module-%oname
Version: 0.5.4
Release: alt1.1
Summary: Validate library for python 3
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/dirty-validators/

# https://github.com/alfred82santa/dirty-validators.git
Source0: %name-%version.tar
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
BuildRequires: python3(dirty_models)
BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
BuildRequires: python3(nose2)
%endif

# PEP503 normalized name
%py3_provides %oname

%description
Agnostic validators for python 3.

Features:

* Python 3 package.
* Easy to create a validator.
* Chained validations.
* Conditional validations.
* Specific error control messages.
* Dirty model integration
* No database dependent.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
# requires aiounittest, nose2 doesn't support skip on module level
rm tests/dirty_validators/tests_async_complex.py
%tox_check_pyproject

%files
%doc *.rst
%python3_sitelibdir/dirty_validators/
%python3_sitelibdir/dirty_validators-%version.dist-info/

%changelog
