%define mname dogpile
%define oname %mname.cache

%def_with check

Name: python3-module-%oname
Version: 1.4.0
Release: alt1.1

Summary: A caching front-end based on the Dogpile lock

License: MIT
Group: Development/Python3
URL: https://pypi.org/project/dogpile.cache
VCS: https://github.com/sqlalchemy/dogpile.cache

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-pbr
BuildRequires: python3-module-tox
BuildRequires: python3-module-pytest
BuildRequires: python3-module-mako
BuildRequires: python3-module-decorator
BuildRequires: python3-module-stevedore
%endif

Provides: python3-module-dogpile-cache = %EVR
Obsoletes: python3-module-dogpile-cache < %EVR
Provides: python3-module-dogpile-core = %EVR
Obsoletes: python3-module-dogpile-core < %EVR

%py3_provides %oname
%py3_provides %mname.core

%description
A caching API built around the concept of a "dogpile lock", which allows
continued access to an expiring data value while a single thread
generates a new value.

dogpile.cache builds on the dogpile.core locking system, which
implements the idea of "allow one creator to write while others read" in
the abstract. Overall, dogpile.cache is intended as a replacement to the
Beaker caching system, the internals of which are written by the same
author. All the ideas of Beaker which "work" are re-implemented in
dogpile.cache in a more efficient and succinct manner, and all the cruft
(Beaker's internals were first written in 2005) relegated to the trash
heap.

%prep
%setup
sed -i 's/license = "MIT"/license = {file = "LICENSE"}/' pyproject.toml
sed -i '/license-files/d' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

%if "%_libexecdir" != "%_libdir"
mv %buildroot%_libexecdir %buildroot%_libdir
%endif

%check
%tox_check_pyproject

%files
%doc LICENSE *.rst
%python3_sitelibdir/%mname
%python3_sitelibdir/%{pyproject_distinfo %oname}/

%changelog
