%define oname freetype

Name: python3-module-%oname
Version: 2.4.0
Release: alt1

Summary: Freetype python bindings
License: BSD
Group: Development/Python3
Url: https://pypi.python.org/pypi/freetype-py/

BuildArch: noarch

# https://github.com/rougier/freetype-py.git
Source: %name-%version.tar
Patch1: %oname-1.1-alt-build.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: pyinstaller
BuildRequires: python3-module-setuptools_scm
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinx_rtd_theme
BuildRequires: libfreetype

BuildRequires: /proc

Requires: lib%oname

%description
Freetype python provides bindings for the FreeType library. Only the
high-level API is bound.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
Freetype python provides bindings for the FreeType library. Only the
high-level API is bound.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Freetype python provides bindings for the FreeType library. Only the
high-level API is bound.

This package contains documentation for %oname.

%prep
%setup
%patch1 -p1

sed -i 's|sphinx-build|&-3|' doc/Makefile

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_install

%make -C doc pickle
%make -C doc html

cp -fR doc/_build/pickle %buildroot%python3_sitelibdir/%oname/

%check
%tox_check_pyproject

%files
%doc *.rst *.txt
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/pickle

%files pickles
%python3_sitelibdir/*/pickle

%files docs
%doc examples doc/_build/html

%changelog
