%define oname fs

%def_with check
%def_with docs

Name: python3-module-%oname
Version: 2.4.16
Release: alt1.2

Summary: Filesystem abstraction layer

License: MIT
Group: Development/Python3
Url: https://pypi.org/project/fs

BuildArch: noarch

# https://github.com/PyFilesystem/pyfilesystem2.git
Source: %name-%version.tar

# Fix tests due to girar environment
#
# girar uses non-default(1) hidepid mount option for /proc.
# Python psutil doesn't expect an inaccessibility of non-user
# components of /proc. The 'children' method recursively tries
# to get the parent pid for all the processes using /proc.
# Actually, ftp daemon has been stopped and then check for
# children processes and tcp connections is performed. For now,
# this assertion can be relaxed.
Patch: fs-2.4.11-alt-fix-tests-due-to-girar-environment.patch

BuildRequires(pre): rpm-build-python3
%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinx_rtd_theme
BuildRequires: python3-module-recommonmark
BuildRequires: python3-module-six
%endif

%if_with check
BuildRequires: /proc
BuildRequires: python3-module-pytest
BuildRequires: python3-module-appdirs
BuildRequires: python3-module-pyftpdlib-tests
BuildRequires: python3-module-parameterized
BuildRequires: python3-module-six
%endif

%description
PyFilesystem is an abstraction layer for filesystems. In the same way
that Python's file-like objects provide a common way of accessing files,
PyFilesystem provides a common way of accessing entire filesystems. You
can write platform-independent code to work with local files, that also
works with any of the supported filesystems (zip, ftp, S3 etc.).

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
PyFilesystem is an abstraction layer for filesystems. In the same way
that Python's file-like objects provide a common way of accessing files,
PyFilesystem provides a common way of accessing entire filesystems. You
can write platform-independent code to work with local files, that also
works with any of the supported filesystems (zip, ftp, S3 etc.).

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
PyFilesystem is an abstraction layer for filesystems. In the same way
that Python's file-like objects provide a common way of accessing files,
PyFilesystem provides a common way of accessing entire filesystems. You
can write platform-independent code to work with local files, that also
works with any of the supported filesystems (zip, ftp, S3 etc.).

This package contains documentation for %oname.

%prep
%setup
%patch -p1

# hotfix for python3.12
sed -i 's/assertRaisesRegexp/assertRaisesRegex/' fs/test.py

%if_with docs
%prepare_sphinx3 .
ln -s ../objects.inv docs/
%endif

%build
%python3_build

%if_with docs
export PYTHONPATH=%buildroot%python3_sitelibdir
%make SPHINXBUILD="sphinx-build-3" -C docs html
%make SPHINXBUILD="sphinx-build-3" -C docs man
%endif

%install
%python3_install

%if_with docs
mkdir -p %buildroot%_man1dir
cp -fr docs/build/man/*.1 %buildroot%_man1dir
%endif

%check
py.test3 -vv -k 'not test_create'

%files
%doc LICENSE *.md
%python3_sitelibdir/fs/
%python3_sitelibdir/fs-*.egg-info/
%if_with docs
%_man1dir/*
%endif

%if_with docs
%files docs
%doc docs/build/html/*
%endif

%changelog
