%define _unpackaged_files_terminate_build 1
%define oname guessit

%def_with check

Name: python3-module-%oname
Version: 3.8.0
Release: alt1

Summary: GuessIt - a library for guessing information from video files

License: LGPLv3
Group: Development/Python3
Url: https://pypi.org/project/guessit/

# https://github.com/guessit-io/guessit.git
Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
# install_requires=
BuildRequires: python3(rebulk)
BuildRequires: python3(babelfish)
BuildRequires: python3(dateutil)

BuildRequires: python3(yaml)
BuildRequires: python3(pytest)
BuildRequires: python3(pytest_mock)
BuildRequires: python3(tox)
BuildRequires: python3(tox_console_scripts)
%endif

%description
GuessIt is a python library that extracts as much information as
possible from a video file.

It has a very powerful filename matcher that allows to guess a lot of
metadata from a video using its filename only. This matcher works with
both movies and tv shows episodes.

%prep
%setup
%autopatch -p1

# remove mimetypes from test data, see https://github.com/guessit-io/guessit/pull/515
# TODO: consider removing following line on next release after 2.1.4
sed -i -e '/mimetype:/d' guessit/test/*.yml

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest

%files
%doc *.md
%_bindir/guessit
%python3_sitelibdir/%oname/
%python3_sitelibdir/%oname-%version.dist-info/
%exclude %python3_sitelibdir/*/test/

%changelog
