%define _unpackaged_files_terminate_build 1
%define oname gunicorn

%def_with check

Name: python3-module-%oname
Version: 23.0.0
Release: alt1

Summary: WSGI HTTP Server for UNIX

License: MIT
Group: Development/Python3
Url: https://pypi.org/project/gunicorn
Vcs: https://github.com/benoitc/gunicorn

Source: %name-%version.tar

BuildArch: noarch

Conflicts: python-module-%oname
Provides: %oname = %version-%release

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-gevent
BuildRequires: python3-module-eventlet
BuildRequires: python3-module-pytest
%endif

%description
Gunicorn 'Green Unicorn' is a Python WSGI HTTP Server for UNIX. It's a
pre-fork worker model ported from Ruby's Unicorn project. The Gunicorn
server is broadly compatible with various web frameworks, simply
implemented, light on server resource usage, and fairly speedy.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

# compibility
ln -s gunicorn %buildroot%_bindir/gunicorn.py3

%check
%pyproject_run_pytest -v -o=addopts="--assert=plain"

%files
%doc README.*
%_bindir/gunicorn
%_bindir/gunicorn.py3
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
