%define _unpackaged_files_terminate_build 1
%define pypi_name invoke

%def_with check

Name: python3-module-%pypi_name
Version: 2.2.0
Release: alt1
Summary: Pythonic task execution
License: BSD-2-Clause
Group: Development/Python3
Url: https://pypi.org/project/invoke/
Vcs: https://github.com/pyinvoke/invoke
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch1: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
%pyproject_runtimedeps -- vendored
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
BuildRequires: /dev/pts
%add_pyproject_deps_check_filter alabaster types-
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%pyproject_builddeps -- vendored
%endif

%description
Invoke is a Python (2.6+ and 3.2+) task execution tool & library,
drawing inspiration from various sources to arrive at a powerful & clean
feature set.

%prep
%setup
%autopatch -p1

# gen vendored list for upstream
set -o pipefail
%__python3 - <<-'EOF' | sort -u > _vendor.txt
import pkgutil
for mod in pkgutil.iter_modules(["invoke/vendor"]):
    if not mod.name.startswith("_") and mod.name != "fluidity":
        print(mod.name)
EOF

%pyproject_deps_resync vendored pip_reqfile _vendor.txt
# drop everything except fluidity (not packaged (unmaintained))
find invoke/vendor/ \
    -mindepth 1 -maxdepth 1 \
    \( ! \( -name '__init__.py' -type f \) -a ! \( -name 'fluidity' -type d \) \) \
    -exec rm -rfv '{}' +

%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile dev-requirements.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- inv test

%files
%doc README.*
%_bindir/inv
%_bindir/invoke
%python3_sitelibdir/invoke/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
