%define _unpackaged_files_terminate_build 1

%define pypi_name jedi
%define mod_name %pypi_name

%def_enable check

Name: python3-module-%pypi_name
Version: 0.19.2
Release: alt1
Summary: An autocompletion tool for Python that can be used for text editors
License: MIT
Group: Development/Python
Url: https://pypi.org/project/jedi/
Vcs: https://github.com/davidhalter/jedi
BuildArch: noarch
Source0: %name-%version.tar
Source1: %pyproject_deps_config_name
Source2: modules.tar
Patch0: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_enabled check
%pyproject_builddeps_metadata_extra testing
# sqlite3 is subpackaged but required by test_sqlite3_conversion
BuildRequires: python3-modules-sqlite3
%endif

%description
Jedi is a static analysis tool for Python that is typically used in IDEs/editors
plugins. Jedi has a focus on autocompletion and goto functionality. Other
features include refactoring, code search and finding references.

Jedi has a simple API to work with. There is a reference implementation as a
VIM-Plugin. Autocompletion in your REPL is also possible, IPython uses it
natively and for the CPython REPL you can install it. Jedi is well tested and
bugs should be rare.

%prep
%setup -a2
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra

%files
%doc README.*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
