%define _unpackaged_files_terminate_build 1

%define oname jupyter_client

%def_with check

Name: python3-module-%oname
Version: 8.6.3
Release: alt1
Summary: Jupyter protocol implementation and client libraries
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/jupyter-client/
Vcs: https://github.com/jupyter/jupyter_client/

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
%if_with check
BuildRequires: python3-module-ipykernel
BuildRequires: python3-module-ipython
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-jupyter
BuildRequires: python3-module-pytest-timeout
BuildRequires: python3-module-pytest-asyncio
BuildRequires: python3-module-pytest-rerunfailures
BuildRequires: openssh-clients
BuildRequires: iproute2
BuildRequires: python3-module-pexpect
%endif

%py3_provides %oname

# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %oname} = %EVR

%description
jupyter_client contains the reference implementation of the Jupyter protocol.
It also provides client and kernel management APIs for working with kernels.

It also provides the jupyter kernelspec entrypoint for installing
kernelspecs for use with Jupyter frontends.

%prep
%setup
sed -i '/--color=yes/d' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

%check
sed -i '/localinterfaces._load_ips_ifconfig/d' tests/test_localinterfaces.py
%pyproject_run_pytest -v -p asyncio -p rerunfailures --reruns=3 -p timeout \
	-k "not test_input_request"

%files
%doc *.md
%_bindir/*
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info


%changelog
