%define _unpackaged_files_terminate_build 1
%define pypi_name kafka-python
%define mod_name kafka

%def_with check

Name: python3-module-%mod_name
Version: 2.0.2
Release: alt5
Summary: Pure Python client for Apache Kafka
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/kafka-python/
VCS: https://github.com/dpkp/kafka-python.git
BuildArch: noarch
Source: %name-%version.tar
Source1: debundler.py.in
Source2: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter docker-py
%add_pyproject_deps_check_filter sphinx
%pyproject_builddeps_metadata
%pyproject_builddeps_check
BuildRequires: python3-module-six
%endif

%filter_from_requires /python3(kafka\.vendor\..*)/d
%py3_requires six

%py3_provides %pypi_name
Provides: python3-module-%pypi_name

%description
This module provides low-level protocol support for Apache Kafka as well
as high-level consumer and producer classes. Request batching is
supported by the protocol as well as broker-aware request routing. Gzip
and Snappy compression is also supported for message sets.

%prep
%setup
%patch -p1

%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile requirements-dev.txt
%endif

VENDORED_PATH='kafka/vendor'
UNVENDORED_PATH="$VENDORED_PATH/__init__.py"
rm -r "$VENDORED_PATH"
mkdir "$VENDORED_PATH"
cp "%SOURCE1" "$UNVENDORED_PATH"
sed -i \
    -e 's/@VENDORED_ROOT@/"kafka.vendor"/' \
    -e 's/@VENDORED_FAKE_PACKAGES@/None/' \
    "$UNVENDORED_PATH"

%build
%pyproject_build

%install
%pyproject_install

# since we are packaging example.py as doc
sed -i '1{/#!/d}' example.py
chmod -x example.py

%check
%pyproject_run_pytest -ra -Wignore

%files
%doc *.md example.py
%python3_sitelibdir/kafka/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
