%define oname libcloud

Name: python3-module-%oname
Version: 3.7.0
Release: alt1

Summary: Library for interacting with popular cloud service

License: Apache-2.0
Group: Development/Python3
Url: http://libcloud.apache.org/

BuildArch: noarch

# Source-git: https://github.com/apache/libcloud
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-module-requests
BuildPreReq: python3-module-urllib3

%py3_provides libcloud.compute.drivers.vsphere

# for docs
BuildPreReq: python3-module-sphinx
# for tests
%py3_requires mock requests requests_mock pytest

%description
Apache Libcloud is a Python library which hides differences between 
different cloud provider APIs and allows you to manage different 
cloud resources through a unified and easy to use API.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
Apache Libcloud is a Python library which hides differences between 
different cloud provider APIs and allows you to manage different 
cloud resources through a unified and easy to use API.

This package contains tests for %oname

%package docs
Summary: Documentation for %name
Group: Development/Documentation

%description docs
Apache Libcloud is a Python library which hides differences between 
different cloud provider APIs and allows you to manage different 
cloud resources through a unified and easy to use API.

This package contains documentation for %oname

%prep
%setup
sed -i 's/requests.packages.//' %oname/http.py
cp libcloud/test/secrets.py-dist libcloud/test/secrets.py

%build
%python3_build

export PYTHONPATH=$PWD
%make SPHINXBUILD="sphinx-build-3" -C docs man

%install
%python3_install

%files
%doc *.rst LICENSE example_*.py
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/test

%files tests
%python3_sitelibdir/libcloud/test/*

%files docs
%doc docs/_build/*


%changelog
