%define _unpackaged_files_terminate_build 1
%define pypi_name livereload

%def_with check

Name: python3-module-%pypi_name
Version: 2.7.1
Release: alt1

Summary: Python LiveReload is an awesome tool for web developers
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/livereload/
Vcs: https://github.com/lepture/python-livereload

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-tornado
%endif

# we have several versions of Django
# so, we cannot rely on auto-requires
%filter_from_requires /^python3(django\(\..*\)\?)/d

%description
LiveReload provides a command line utility, livereload, for starting
a server in a directory. By default, it will listen to port 35729,
the common port for LiveReload browser extensions. LiveReload is designed
for web developers who know Python.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
# https://github.com/lepture/python-livereload/issues/200
%pyproject_run_pytest -v -k 'not test_watch_multiple_dirs'

%files
%doc README.* CHANGES.rst
%_bindir/%pypi_name
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%pypi_name-%version.dist-info

%changelog
