%define _unpackaged_files_terminate_build 1
%define oname logilab-common

%def_with check

Name: python3-module-%oname
Version: 2.0.0
Release: alt3

Summary: Collection of low-level Python packages and modules used by Logilab projects
License: LGPLv2.1+
Group: Development/Python3
Url: https://pypi.org/project/logilab-common

BuildArch: noarch

Source: %oname-%version.tar
Patch0: logilab-1.10.0-alt-urllib2.patch
Patch1: lc-2.0.0-unittest-alt-fix.patch
Patch2: lc-2.0.0-tests-make-tests-compatible-with-pytest-8.2.0.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-mypy_extensions
BuildRequires: python3-module-typing_extensions
BuildRequires: python3-module-pytz
BuildRequires: python3-module-pytest
%endif

%py3_provides logilab

%description
logilab-common is a collection of low-level Python packages and modules,
designed to ease:
  * handling command line options and configuration files
  * writing interactive command line tools
  * manipulation files and character strings
  * interfacing to OmniORB (removed by packager)
  * generating of SQL queries
  * running unit tests
  * manipulating tree structures
  * accessing RDBMS (currently postgreSQL, mysql and sqlite)
  * generating text and HTML reports
  * logging

%prep
%setup -n %oname-%version
%patch0 -p1
%patch1 -p2
%patch2 -p2

%build
%pyproject_build

%install
%pyproject_install
rm -f %buildroot%_bindir/logilab-pytest

%check
%pyproject_run_pytest -v -k 'not test_deprecation'

%files
%doc README.rst COPYING
%python3_sitelibdir/logilab
%python3_sitelibdir/%{pyproject_distinfo %oname}
%python3_sitelibdir/logilab_common-%version-*-nspkg.pth

%changelog
