%define oname logilab-database

%def_with check

Name: python3-module-%oname
Version: 2.0
Release: alt1

Summary: Provides some classes to make unified access to different RDBMS possible
License: LGPLv2.1+
Group: Development/Python3
URL: https://pypi.org/project/logilab-database

BuildArch: noarch

Source: database-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-logilab-common
BuildRequires: python3-modules-sqlite3
BuildRequires: python3-module-dateutil
BuildRequires: python3-module-psycopg2
BuildRequires: python3-module-yapps2
%endif

%description
logilab-database provides some classes to make unified access to
different RDBMS possible:

* actually compatible db-api from different drivers to postgres, mysql,
  sqlite and sqlserver
* additional api for full text search
* extensions functions for common tasks such as creating database,
  index, users, dump and restore, etc...
* sql generation for INSERT/UPDATE/DELETE (in sqlgen.py)

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v

%files
%doc ChangeLog README.*
%python3_sitelibdir/logilab
%python3_sitelibdir/logilab_database-%version.dist-info
%python3_sitelibdir/logilab_database-%version-*-nspkg.pth

%changelog
