%define  oname mocket

%def_with check

Name:    python3-module-%oname
Version: 3.12.8
Release: alt2

Summary: Python socket mock framework

License: BSD-3-Clause
Group:   Development/Python3
URL:     https://pypi.org/project/mocket
VCS:     https://github.com/mindflayer/python-mocket

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): python3-module-hatchling

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-cov
BuildRequires: python3-module-urllib3
BuildRequires: python3-module-decorator
BuildRequires: python3-module-http-parser
BuildRequires: python3-module-pook
BuildRequires: python3-module-requests
BuildRequires: python3-module-aiohttp
BuildRequires: python3-module-sure
BuildRequires: python3-module-redis-py
BuildRequires: python3-module-httpx
BuildRequires: python3-module-fastapi
BuildRequires: python3-module-httptools
BuildRequires: python3-module-psutil
BuildRequires: python3-module-asgiref
%endif

BuildArch: noarch

Source:  %name-%version.tar

%description
Socket Mock Framework - for all kinds of socket animals, web-clients
included, with gevent/asyncio/SSL support.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
export SKIP_TRUE_HTTP=1
export LANG=en_US.UTF-8
# TrueRedisTestCase requires a running Redis server
# other checks trying to record a real request and response
py.test-3 -k "not test_file_object and \
              not test_truesendall_with_dump_from_recording and \
              not test_asyncio_record_replay and \
              not TrueRedisTestCase"

%files
%doc LICENSE *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
