%define _unpackaged_files_terminate_build 1

%define pypi_name nbformat

%def_with check

Name: python3-module-%pypi_name
Version: 5.10.4
Release: alt1
Summary: The Jupyter Notebook format
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/nbformat
Vcs: https://github.com/jupyter/nbformat

BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-hatch-nodejs-version
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-testpath
BuildRequires: python3-module-pep440
BuildRequires: python3-module-traitlets
BuildRequires: python3-module-jsonschema
BuildRequires: python3-module-fastjsonschema
BuildRequires: python3-module-jupyter_core
BuildRequires: python3-modules-sqlite3
%endif

%py3_provides %pypi_name
%py3_requires traitlets jsonschema fastjsonschema jupyter_core

%description
This package contains the base implementation of the Jupyter Notebook
format, and Python APIs for working with notebooks.

%prep
%setup

# Remove useless test dependencies
sed -i '/"pre-commit",/d' pyproject.toml
sed -i '/"check-manifest",/d' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v --color=no

%files
%doc README.*
%_bindir/jupyter-trust
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
