%define _unpackaged_files_terminate_build 1
%define pypi_name netius
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 1.20.0
Release: alt1
Summary: Fast and readable async non-blocking network apps
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/netius/
Vcs: https://github.com/hivesolutions/netius
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
BuildRequires: python3-module-pytest
%endif

%description
Netius is a Python network library that can be used for the rapid
creation of asynchronous non-blocking servers and clients. It has no
dependencies, it's cross-platform, and brings some sample netius-powered
servers out of the box, namely a production-ready WSGI server.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install
# link to system ca bundle, wheel resolves it and makes a copy
ln -sf /etc/pki/tls/certs/ca-bundle.crt \
    %buildroot/%python3_sitelibdir/%mod_name/base/extras/net.ca

%check
%pyproject_run_pytest -vra

%files
%doc *.rst
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/*/test
%exclude %python3_sitelibdir/*/examples

%changelog
