%define oname oauth2client

Name: python3-module-%oname
Version: 4.1.3
Release: alt5

Summary: OAuth 2.0 client library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.python.org/pypi/oauth2client/

# https://github.com/google/oauth2client.git
# Source-url: %__pypi_url %oname
Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: %name-%version.tar
Patch1: %oname-%version-gentoo-py38.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3

BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx

BuildRequires: python3-module-httplib2 python3-module-keyring python3-module-pyasn1-modules python3-module-rsa
BuildRequires: python3-module-mock python3-module-fasteners python3-module-flask
BuildRequires: python3(sqlalchemy)
BuildRequires: python3-module-pytest
BuildRequires: python3(Crypto)

%add_python3_req_skip google.appengine.api google.appengine.ext google.appengine.ext.webapp.util
%add_python3_req_skip google webapp2

%description
The oauth2client is a client library for OAuth 2.0.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
The oauth2client is a client library for OAuth 2.0.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
The oauth2client is a client library for OAuth 2.0.

This package contains documentation for %oname.

%package -n python3-module-django-%oname
Summary:        Django extension
Group: Development/Python3
PreReq: %name = %EVR

%description -n python3-module-django-%oname
OAuth 2.0 utilities for Django.

Utilities for using OAuth 2.0 in conjunction with
the Django datastore.

%package flask
Summary: Flask extension
Group: Development/Python3
PreReq: %name = %EVR

%description flask
Provides a Flask extension that makes using OAuth2 web server flow easier.
The extension includes views that handle the entire auth flow and a
``@required`` decorator to automatically ensure that user credentials are
available.

%package gce
Summary: GCE extension
Group: Development/Python3
PreReq: %name = %EVR

%description gce
Utilities for Google Compute Engine

Utilities for making it easier to use OAuth 2.0 on Google Compute Engine.

%prep
%setup
%patch1 -p1

%prepare_sphinx3 .
ln -s ../objects.inv docs/

%build
%python3_build_debug

%install
%python3_install
%python3_prune

%check
rm -rf tests/contrib/{django_util,appengine}
py.test3 || :

%files
%doc *.md
%python3_sitelibdir/*
#%exclude %python_sitelibdir/*/pickle

%exclude %python3_sitelibdir/oauth2client/contrib/flask*
%exclude %python3_sitelibdir/oauth2client/contrib/django*
%exclude %python3_sitelibdir/oauth2client/contrib/gce*

%files flask
%python3_sitelibdir/oauth2client/contrib/flask*

%files -n python3-module-django-%oname
%python3_sitelibdir/oauth2client/contrib/django*

%files gce
%python3_sitelibdir/oauth2client/contrib/gce*

%changelog
