%define  modulename openshift

Name:    python3-module-%modulename
Version:  0.13.2
Release:  alt1

Summary:  OpenShift python client
License:  Apache-2.0
Group:    Other
Url:      https://github.com/openshift/openshift-restclient-python
Vcs:      https://github.com/openshift/openshift-restclient-python.git
BuildArch:  noarch

Packager: Andrew A. Vasilyev <andy@altlinux.org>

Source:   %modulename-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3-module-flake8 pytest3 python3-module-openshift

%description
Python client for the Kubernetes and OpenShift APIs.

%prep
%setup -n %modulename-%version
sed -i -e 's/pytest/pytest3/' Makefile tox.ini
# Remove unknown options
sed -i -e 's/--cov-append/--import-mode=append/' -e '/--cov-report=html/d' -e '/--cov=openshift/d' setup.cfg
rm -f test/unit/test_diff.py
# No kubernetes here
sed -i -e 's/ test-integration$//' Makefile

%build
%pyproject_build

%install
%pyproject_install
rm -rf %buildroot/usr/requirements.txt

%check
make test PYTHON=%__python3

%files
%doc *.md LICENSE *.txt
%python3_sitelibdir/*

%changelog
