%define oname os-brick
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 6.3.0
Release: alt1.1

Summary: OpenStack Cinder brick library for managing local volume attaches

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/os-brick

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 5.8.0
BuildRequires: python3-module-oslo.concurrency >= 5.0.0
BuildRequires: python3-module-oslo.context >= 4.1.0
BuildRequires: python3-module-oslo.config >= 9.0.0
BuildRequires: python3-module-oslo.log >= 4.8.0
BuildRequires: python3-module-oslo.i18n >= 5.1.0
BuildRequires: python3-module-oslo.privsep >= 3.0.0
BuildRequires: python3-module-oslo.service >= 2.8.0
BuildRequires: python3-module-oslo.serialization >= 4.3.0
BuildRequires: python3-module-oslo.utils >= 6.0.0
BuildRequires: python3-module-os-win >= 5.7.0
BuildRequires: python3-module-requests >= 2.25.1
BuildRequires: python3-module-tenacity >= 6.3.1

%if_with check
BuildRequires: python3-module-hacking >= 5.0.0
BuildRequires: python3-module-coverage >= 5.5
BuildRequires: python3-module-ddt >= 1.4.1
BuildRequires: python3-module-testtools >= 2.4.0
BuildRequires: python3-module-stestr >= 3.2.1
BuildRequires: python3-module-oslo.vmware >= 4.0.0
BuildRequires: python3-module-castellan >= 3.10.0
BuildRequires: python3-module-doc8 >= 0.8.1
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-bandit >= 1.7.0
BuildRequires: python3-module-mypy >= 1.1.1
BuildRequires: python3-module-castellan-tests
BuildRequires: python3-module-oslotest >= 4.5.0
BuildRequires: python3-module-testscenarios >= 0.5.0
BuildRequires: python3-module-eventlet >= 0.30.1
%endif

%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-openstackdocstheme
%endif

%description
This project containing classes that help with volume discovery and removal
from a host.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# reno is not used, after openstack moved on openstackdocstheme
find . -name "conf.py" | xargs sed -i '/reno/d'

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/%oname.1 %buildroot%_man1dir/%oname.1
%endif

# Move config files to proper location
install -d -m 755 %buildroot%_sysconfdir/%oname/rootwrap.d
mv %buildroot/usr/etc/os-brick/rootwrap.d/*.filters %buildroot%_sysconfdir/%oname/rootwrap.d

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%dir %_sysconfdir/%oname
%dir %_sysconfdir/%oname/rootwrap.d
%config(noreplace) %_sysconfdir/%oname/rootwrap.d/*
%python3_sitelibdir/os_brick
%python3_sitelibdir/os_brick-%version.dist-info
%exclude %python3_sitelibdir/os_brick/tests

%files tests
%python3_sitelibdir/os_brick/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/%oname.1.xz
%endif

%changelog
