%define oname oslo.context
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 5.7.1
Release: alt1.1

Summary: OpenStack Oslo Context library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/oslo.context

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

Provides: python3-module-oslo-context = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-debtcollector >= 1.2.0

%if_with check
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-hacking >= 6.1.0
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-mypy >= 0.761
BuildRequires: python3-module-bandit >= 1.7.0
BuildRequires: python3-module-pre-commit >= 2.6.0
%endif

%if_with docs
BuildRequires: python3-module-sphinx >= 1.6.2
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
%endif

%description
The Oslo context library has helpers to maintain useful information
about a request context. The request context is usually populated in
the WSGI pipeline and used by various modules such as logging.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation
Provides: python3-module-oslo-context-doc = %EVR

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/oslocontext.1 %buildroot%_man1dir/oslocontext.1
%endif

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%python3_sitelibdir/oslo_context
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/oslo_context/tests

%files tests
%python3_sitelibdir/oslo_context/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/oslocontext.1.xz
%endif

%changelog
