%define oname oslo.rootwrap
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 7.5.1
Release: alt1.1

Summary: OpenStack Oslo Rootwrap

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/oslo.rootwrap

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

Provides: python3-module-oslo-rootwrap = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-debtcollector >= 3.0.0
BuildRequires: python3-module-oslotest >= 3.2.0

%if_with check
BuildRequires(pre): schedutils
BuildRequires(pre): iproute2
BuildRequires: python3-module-mock >= 2.0.0
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-testtools >= 2.2.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-eventlet >= 0.18.2
BuildRequires: /proc
%endif

%if_with docs
BuildRequires: python3-module-sphinx >= 1.6.2
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
%endif

%description
The Oslo Rootwrap allows fine filtering of shell commands to run as `root`
from OpenStack services.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation
Provides: python3-module-oslo-rootwrap-doc = %EVR

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/oslorootwrap.1 %buildroot%_man1dir/oslorootwrap.1
%endif

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
# Functional tests with Eventlet involve monkeypatching, so force them to be
# run in a separate process
%__python3 -m stestr run --exclude-regex tests.test_functional_eventlet
TEST_EVENTLET=1 %__python3 -m stestr run tests.test_functional_eventlet

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%_bindir/oslo-rootwrap
%_bindir/oslo-rootwrap-daemon
%python3_sitelibdir/oslo_rootwrap
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/oslo_rootwrap/tests

%files tests
%python3_sitelibdir/oslo_rootwrap/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/oslorootwrap.1.xz
%endif

%changelog
