%define oname peewee-async

%def_without check

Name: python3-module-%oname
Version: 0.10.0
Release: alt1

Summary: Asynchronous interface for peewee ORM powered by asyncio

License: MIT
Group: Development/Python3
URL: https://pypi.org/project/peewee-async
VCS: https://github.com/05bit/peewee-async

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-poetry

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-asyncio
BuildRequires: python3-module-peewee
BuildRequires: python3-module-importlib_metadata
%endif

%py3_provides peewee_async
%py3_requires asyncio peewee aiopg

%description
peewee-async is a library providing asynchronous interface powered by
asyncio for peewee ORM.

%prep
%setup

sed -i 's/0.9.1/%version/' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest

%files
%doc LICENSE *.md
%python3_sitelibdir/peewee_async.py
%python3_sitelibdir/peewee_asyncext.py
%python3_sitelibdir/peewee_async-%version.dist-info
%python3_sitelibdir/__pycache__

%changelog
