%define _unpackaged_files_terminate_build 1
%define oname py

Name: python3-module-%oname
Version: 1.11.0
Release: alt1

Summary: Testing and distributed programming library
License: MIT
Group: Development/Python3
# Source-git: https://github.com/pytest-dev/py.git
Url: https://github.com/pytest-dev/py

Source: %name-%version.tar
Source2: move.list
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools_scm)
BuildRequires: python3(apipkg)

BuildArch: noarch

%define move_list %(echo `cat %SOURCE2`)

# The compiler package has been removed in Python 3
%add_python3_req_skip compiler
%py3_provides %move_list
%py3_requires apipkg
%py3_requires iniconfig

%description
The py lib has several namespaces which help with testing, generating
and distributing code across machines.

%prep
%setup
%patch0 -p1

# remove bundled packages
rm -r py/_vendored_packages

%build
# SETUPTOOLS_SCM_PRETEND_VERSION: when defined and not empty,
# its used as the primary source for the version number in which
# case it will be a unparsed string
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_install

# check the actual provides against predefined ones
set -o pipefail
PYTHONPATH="$(pwd)" python3 -c "import py, apipkg;\
assert py.__version__==\"%version\";\
modules=[ 'py.' + mod for mod in dir(py) if isinstance(getattr(py, mod), apipkg.ApiModule) ];\
print(*modules, sep='\n')" | sort > move.actual.list
set +o pipefail
cat %SOURCE2 | sort > move.expected.list
diff -y move.expected.list move.actual.list

%check

%files
%doc CHANGELOG.rst README.rst LICENSE
%python3_sitelibdir/%oname/
%python3_sitelibdir/%oname-%version-py%_python3_version.egg-info/

%changelog
