%define pypi_name pyamg
%define mod_name %pypi_name

%ifarch ppc64le
%def_without check
%else
%def_without check
%endif

Name: python3-module-%pypi_name
Version: 5.2.1
Release: alt1

Summary: PyAMG: Algebraic Multigrid Solvers in Python
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/pyamg/

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(setuptools_scm)
BuildRequires: python3(pybind11)
BuildRequires: python3(wheel)

BuildRequires: gcc-c++

%if_with check
# deps
BuildRequires: python3(numpy)
BuildRequires: python3(scipy)

BuildRequires: python3(numpy.testing)
BuildRequires: python3(pytest)
%endif

%description
PyAMG is a library of Algebraic Multigrid (AMG) solvers with a
convenient Python interface.

%prep
%setup

# setuptools_scm implements a file_finders entry point which returns all files
# tracked by SCM.
if [ ! -d .git ]; then
    git init
    git config user.email author@example.com
    git config user.name author
    git add .
    git commit -m 'release'
    git tag '%version'
fi

%build
%pyproject_build

%install
%pyproject_install

%check
# https://github.com/pyamg/pyamg/issues/342
%ifarch i586
%define _pytest_args -k 'not test_bellman_ford and not test_lloyd_cluster'
%endif
%pyproject_run -- bash -s <<-'ENDTESTS'
set -eux
mkdir empty
cd empty
python -m pytest -ra -Wignore --pyargs %mod_name %{?_pytest_args}
ENDTESTS

%files
%doc *.txt *.md
%python3_sitelibdir/pyamg/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%exclude %python3_sitelibdir/pyamg/tests
%exclude %python3_sitelibdir/pyamg/*/tests

%changelog
