%define pyname pybluez
%define modulename PyBluez

Name: python3-module-pybluez
Version: 0.23
Release: alt1
Summary: A Python module for the Bluez library
Group: Development/Python3
License: GPLv2+
Url: http://code.google.com/p/pybluez/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: libbluez >= 4.0

Source: %url/files/%pyname-%version.tar.gz
Patch: pybluez-py310.patch

BuildRequires: libbluez-devel
BuildRequires(pre): rpm-build-python3

# needs only for macos
%add_python3_req_skip lightblue

%description
PyBluez is an effort to create python wrappers around bluez to allow python
developers to use system bluetooth resources.

%prep
%setup -n %pyname-%version
%patch -p0
sed -i '/2to3/d' setup.py

%build
%add_optflags -fno-strict-aliasing
%python3_build

%install
%python3_install

%files
%doc README.md CHANGELOG COPYING
%python3_sitelibdir/bluetooth
%python3_sitelibdir/*.egg-info
%exclude %python3_sitelibdir/bluetooth/msbt*
%exclude %python3_sitelibdir/bluetooth/widcomm*

%changelog
