%define oname pylama

%def_with check

Name: python3-module-%oname
Version: 8.4.1
Release: alt1.1

Summary: pylama -- Code audit tool for python

License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/pylama/

# https://github.com/klen/pylama.git
Source: %name-%version.tar
Patch: tests-Sync-pylint-s-no-else-return.patch
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-intro
BuildRequires: git-core

BuildRequires: pylint-py3
BuildRequires: python3-module-vulture

# It's really unknown
%add_python3_req_skip unknown_module

# generated by 'epm restore --dry-run' from python3-module-pylama-7.7.1/requirements.txt
%py3_use mccabe >= 0.5.2
%py3_use pycodestyle >= 2.3.1
%py3_use pydocstyle >= 2.0.0
%py3_use pyflakes >= 1.5.0

# generated by 'epm restore --dry-run' from python3-module-pylama-7.7.1/requirements-test.txt
%py3_buildrequires ipdb
%py3_buildrequires pytest
%py3_buildrequires eradicate >= 1.0
%py3_buildrequires radon >= 1.4.2
%py3_buildrequires mypy


Conflicts: python-module-pylama < %EVR
Obsoletes: python-module-pylama < %EVR

%py3_provides %oname

%description
pylama -- Code audit tool for python.

%prep
%setup
%autopatch -p1

%build
export LC_ALL=en_US.UTF-8
%python3_build

%install
export LC_ALL=en_US.UTF-8
%python3_install

# don't install tests in such directory please
rm -rf %buildroot%python3_sitelibdir/tests

%check
export LC_ALL=en_US.UTF-8
# Known error: https://github.com/klen/pylama/issues/219
py.test3 -v -k 'not test_quotes'

%files
%doc Changelog *.rst
%_bindir/%oname
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-py%_python3_version.egg-info

%changelog
