%define _unpackaged_files_terminate_build 1

%define oname pyproj

%def_with check

Name: python3-module-%oname
Version: 3.6.1
Release: alt2
Summary: Python interface to PROJ
License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/pyproj/
VCS: https://github.com/pyproj4/pyproj

Source: %name-%version.tar
Patch: pyproj-3.6.1-fix-test-with-proj-9.4.0.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-Cython
BuildRequires: proj
BuildRequires: proj-devel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-certifi
BuildRequires: python3-module-numpy
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-pandas
BuildRequires: python3-module-xarray
BuildRequires: python3-module-shapely
%endif

%description
Python interface to PROJ (cartographic projections and coordinate
transformations library)

%prep
%setup
%patch -p1

%build
%add_optflags -fno-strict-aliasing
export PROJ_DIR="%_usr/"
export PROJ_LIBDIR="%_libdir"
export PROJ_INCDIR="%_includedir"
%pyproject_build

%install
%pyproject_install

%check
cd ..
mkdir -p pyproj-test-folder
cd pyproj-test-folder
cp -r ../%name-%version/test .
cp -r ../%name-%version/pytest.ini .

PATH="%buildroot%_bindir:$PATH" \
PYTHONPATH=%buildroot%python3_sitelibdir \
py.test-3 -m "not network"

%files
%doc LICENSE* *.md docs
%_bindir/%oname
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}


%changelog
