%define oname pyramid

%def_without bootstrap

Name:           python3-module-%oname
Version:        2.0.2
Release:        alt2
Summary:        The Pyramid web application framework, a Pylons project
Group:          Development/Python3
License:        BSD
URL:            https://trypyramid.com/
BuildArch:      noarch

# https://github.com/Pylons/pyramid.git
Source: %name-%version.tar

Patch: %name-%version.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3(chameleon) python3(mako) python3(repoze.lru)
BuildRequires: python3(venusian) python3(webtest) python3(zope.deprecation)
BuildRequires: python3(docutils) python3(hupper) python3(paste.deploy)
BuildRequires: python3(plaster) python3(plaster_pastedeploy) python3(sphinx)
BuildRequires: python3(translationstring) python3(zope.component) python3(zope.configuration)
BuildRequires: python3(zope.interface) python3(webob)
BuildRequires: pytest3

%py3_requires paste.deploy plaster_pastedeploy

%if_with bootstrap
# break cyclic dependency on bootstrap
%add_python3_req_skip pyramid_zodbconn
%endif

Conflicts: python3-module-%oname =< %version-release

%description
Pyramid is a small, fast, down-to-earth, open source Python web development
framework. It makes real-world web application development and deployment more
fun, more predictable, and more productive.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH="${PWD}/_stub:%buildroot%python3_sitelibdir"
pytest3 tests -v -k "not test_scan_integration and not test_scan_integration_conflict \
	and not test_scan_integration_conflict and not test_scan_integration_dottedname_package \
	and not test_scan_integration_with_ignore and not test_scan_integration_with_onerror \
	and not test_first and not test_second and not test_root and not test_two \
	and not test_rescan and not test_root and not test_two"

%files
%doc README.rst
%python3_sitelibdir/%oname/
%python3_sitelibdir/%{oname}-%{version}*.dist-info
%_bindir/pdistreport
%_bindir/prequest
%_bindir/proutes
%_bindir/pserve
%_bindir/pshell
%_bindir/ptweens
%_bindir/pviews

%changelog
