%define rname pyscard

Name:       python3-module-%rname
Version:    2.0.7
Release:    alt1

Summary:    A framework for building smart card aware applications in Python
License:    LGPLv2+ and Python and CC-BY-SA-3.0
Group:      Development/Python3
URL:        https://sourceforge.net/projects/pyscard/

Source0:    %rname-%version.tar

Patch:      %rname-%version-Pyro5.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

BuildRequires:  python3-module-Pyro5
BuildRequires:  libpcsclite-devel
BuildRequires:  swig >= 1.3.31

Requires:   pcsc-lite
Provides:   pyscard = %version-%release

%description
The pyscard smartcard library is a framework for building smart card
aware applications in Python. The smartcard module is built on top of
the PCSC API Python wrapper module.

%prep
%setup -q -n %rname-%version
%autopatch -p1

# fix import of bsddb
sed -i 's|_bsddb|bsddb3._pybsddb|' smartcard/CardNames.py
sed -i 's|from bsddb import|from bsddb3 import|' smartcard/CardNames.py

%build
%pyproject_build

%install
%pyproject_install

%files
%doc README.md
%doc smartcard/doc/*
%doc smartcard/Examples
%python3_sitelibdir/smartcard
%python3_sitelibdir/%rname-%version.dist-info

%changelog
