%define oname rasterio

%def_with check

Name: python3-module-%oname
Version: 1.4.2
Release: alt1

License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.python.org/pypi/rasterio/

Summary: Fast and direct raster I/O for use with Numpy and SciPy

# Source-url: %__pypi_url %oname
Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-Cython
BuildRequires: libnumpy-py3-devel
BuildRequires: libgdal-devel
BuildRequires: gcc-c++
%if_with check
BuildRequires: /proc
BuildRequires: gdal
BuildRequires: python3-module-affine
BuildRequires: python3-module-attrs
BuildRequires: python3-module-boto3
BuildRequires: python3-module-click
BuildRequires: python3-module-click-plugins
BuildRequires: python3-module-cligj
BuildRequires: python3-module-fsspec
BuildRequires: python3-module-hypothesis
BuildRequires: python3-module-matplotlib
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-pyparsing
BuildRequires: python3-module-pytest
BuildRequires: python3-module-snuggs
%endif

%py3_provides %oname
%py3_requires numpy IPython

%description
Rasterio reads and writes geospatial raster datasets.

Rasterio employs GDAL under the hood for file I/O and raster formatting.
Its functions typically accept and return Numpy ndarrays. Rasterio is
designed to make working with geospatial raster data more productive and
more fun.

%prep
%setup
subst "s|/usr/local/share/proj|/usr/share/proj|" setup.py

# Drop dependency on distutils
sed -i '/from distutils.version/d' rasterio/rio/calc.py

%build
%pyproject_build

%install
%pyproject_install

%check
%ifnarch %ix86 armh
rm -rf %oname # Don't try unbuilt copy.
# Ignore some tests using network access
%pyproject_run_pytest -ra \
    -m 'not network and not wheel' \
    -k 'not test_rio_env_no_credentials and not test_datasetreader_ctor_url and not test_read_boundless and not test_resampling_rms and not test_merge_precision[precision0] and not test_merge_precision[precision1] and not test_create_sidecar_mask and not test_update_tags' \
    -W ignore::pytest.PytestRemovedIn9Warning
%endif

%files
%doc *.txt *.rst docs/ examples/
%_bindir/rio
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}

%changelog
