%define oname relatorio

%def_with check

Name: python3-module-%oname
Version: 0.11.1
Release: alt1.1

Summary: A templating library able to output odt and pdf files
License: GPL-3
Group: Development/Python3
# Upstream uses mercurial repository
URL: https://pypi.org/project/relatorio

Source: %oname-%version.tar.gz
BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)

%if_with check
# install_requires:
BuildRequires: python3(genshi)
BuildRequires: python3(lxml)

# testing
BuildRequires: python3(python-magic)
BuildRequires: python3(tox)
BuildRequires: python3(tox_no_deps)
BuildRequires: python3-module-pytest
%endif

%description
A templating library which provides a way to easily output all kind of
different files (odt, ods, png, svg, ...). Adding support for more
filetype is easy: you just have to create a plugin for this.

relatorio also provides a report repository allowing you to link python
objects and report together, find reports by mimetypes/name/python
objects.

%prep
%setup -n %oname-%version

%build
%pyproject_build

%install
%pyproject_install

# don't package tests
rm -r %buildroot%python3_sitelibdir/%oname/tests/

%check
%tox_create_default_config
%tox_check_pyproject

%files
%doc LICENSE CHANGELOG README.rst
%_bindir/relatorio-render
%python3_sitelibdir/%oname/
%python3_sitelibdir/%oname-%version.dist-info/

%changelog
