%define _unpackaged_files_terminate_build 1

%define oname requests-kerberos
%def_with check

Name: python3-module-%oname
Version: 0.14.0
Release: alt1

Summary: A Kerberos authentication handler for python-requests

License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/requests-kerberos

# https://github.com/requests/requests-kerberos.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-kerberos

%if_with check
BuildRequires: python3-module-mock
BuildRequires: python3-module-requests
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-mock
BuildRequires: python3-module-spnego
%endif

Requires: python3-module-requests >= 1.1
Requires: python3-module-kerberos

%add_python3_req_skip requests.packages.urllib3
%py3_provides %oname

BuildArch: noarch

%description
Requests is an HTTP library, written in Python, for human beings. This
library adds optional Kerberos/GSSAPI authentication support and
supports mutual authentication.

%prep
%setup

%build
%python3_build

%install
%python3_install

%check
python3 -m pytest --verbose

%files
%doc AUTHORS README.rst HISTORY.rst LICENSE
%python3_sitelibdir/requests_kerberos
%python3_sitelibdir/requests_kerberos-%version-*.egg-info

%changelog
