%define _unpackaged_files_terminate_build 1
%define oname requirements-detector
%define mod_name requirements_detector

%def_with check

Name: python3-module-%oname
Version: 1.2.2
Release: alt2

Summary: Python tool to find and list requirements of a Python project
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/requirements-detector/
Vcs: https://github.com/landscapeio/requirements-detector.git
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-poetry-core
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-astroid
BuildRequires: python3-module-semver
BuildRequires: python3-module-toml
%endif

%py3_provides requirements_detector
%py3_requires astroid


%description
requirements-detector is a simple Python tool which attempts to find and
list the requirements of a Python project.

When run from the root of a Python project, it will try to ascertain
which libraries and the versions of those libraries that the project
depends on.

%prep
%setup

# temporary fix for astroid 3.1
sed -i 's/AstroidBuildingException/AstroidBuildingError/' requirements_detector/handle_setup.py

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v

%files
%doc README.*
%_bindir/*
%python3_sitelibdir/%mod_name
%python3_sitelibdir/%mod_name-%version.dist-info


%changelog
