%define _unpackaged_files_terminate_build 1
%define pypi_name rsa
%define mod_name %pypi_name

%def_with check

Name: python3-module-rsa
Version: 4.9
Release: alt2

Summary: Pure-Python RSA implementation
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.python.org/pypi/rsa/
Vcs: https://github.com/sybrenstuvel/python-rsa

# Source-url: %__pypi_url %pypi_name
Source: %name-%version.tar

BuildArch: noarch
# generated by epm --restore --dry-run from rsa/setup.py install_requires
%py3_use pyasn1 >= 0.1.3
BuildRequires(pre): rpm-build-intro >= 2.2.4
BuildRequires(pre): rpm-build-python3
# build backend and its deps
BuildRequires: python3-module-poetry-core

%if_with check
BuildRequires: python3-module-pytest
%endif

%description
Python-RSA is a pure-Python RSA implementation. It supports encryption
and decryption, signing and verifying signatures, and key generation
according to PKCS#1 version 1.5. It can be used as a Python library as
well as on the commandline. The code was mostly written by Sybren A.
Stuvel.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install
%python3_prune

%check
# see .github/workflows/tests.yml and tox.ini
%pyproject_run_pytest -vra -o=addopts='' \
    --doctest-modules \
    --ignore=tests/test_mypy.py \
    %mod_name tests

%files
%doc LICENSE README.md
%_bindir/*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
